/* ==================================================================
   Copyright:   Travellers Tales (UK)
   File:        dlist_FallBack_vs.hlsl
   Author:      Vassilis Poulopoulos
   Date:        22Nov2006
   Format:      PC HLSL
   Description:	Fallback 2D vertex shader

   $Log: not supported by cvs2svn $
   Revision 1.2  2007/06/04 10:37:25  acrowe
   *** empty log message ***

   Revision 1.1.4.1  2007/04/30 11:05:43  vpoulopoulos
   Minor changes

   Revision 1.1  2007/03/26 14:19:28  vpoulopoulos
   Added non-shaderbuilder shaders in separare directory

   Revision 1.2  2007/01/15 10:28:48  vpoulopoulos
   Removed dependency on shared params .fx

   Revision 1.1  2006/11/27 16:23:50  vpoulopoulos
   First commit of PC DLIST shaders


===================================================================== */

// Include shared header file which includes declarations such as:
// - viewProj
#include "VertexShaderSemantics.fx"

struct VS_IN
{
	float4 pos		: POSITION;
	float4 color	: COLOR;
	float2 texcoord	: TEXCOORD0;
};

struct VS_OUT
{
	float4 pos		: POSITION;
	float4 color    : COLOR;
	float2 texcoord : TEXCOORD0;
};

VS_OUT FallBack_vx(VS_IN IN)
{
	VS_OUT OUT;

	OUT.pos 		= IN.pos;
	OUT.color 		= IN.color;
	OUT.texcoord	= IN.texcoord;
	
	return OUT;
}

VS_OUT FallBack3D_vx(VS_IN IN)
{
	VS_OUT OUT;

	OUT.pos 		= mul(IN.pos, viewProj);
	OUT.color 		= IN.color;
	OUT.texcoord	= IN.texcoord;
	
	return OUT;
}

sampler2D diffuse_tex : register(s0);

float4 FallBack_px(VS_OUT IN) : COLOR
{
	return 	tex2D(diffuse_tex, IN.texcoord.xy) * IN.color;
}

float4 FallBackTex_px(VS_OUT IN) : COLOR
{
	return 	tex2D(diffuse_tex, IN.texcoord.xy);
}

float4 White_px() : COLOR
{
	return 1;
}

float4 Black_px() : COLOR
{
	return float4(0,0,0,1);
}

float4 g_DepthScaleOffset : register(c0);

float4 RenderDepth_px(VS_OUT IN) : COLOR
{
	float depth = tex2D(diffuse_tex, IN.texcoord.xy).r;
	
	depth = (depth - g_DepthScaleOffset.x) / (1.0 - g_DepthScaleOffset.x);
	//depth = 1.0 - (g_DepthScaleOffset.x - depth) / (g_DepthScaleOffset.x);

	return float4(depth, depth, depth, 1);
}